/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.widgets.QDCheckBoxMenuItem;
import com.quantumdata.widgets.QDMenu;
import com.quantumdata.widgets.QDSeparator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class WindowMenu
extends QDMenu {
    private static final long serialVersionUID = 1L;
    private JSeparator m_winSep;

    public WindowMenu() {
        this.init();
    }

    public WindowMenu(String string) {
        super(string);
        this.init();
    }

    public WindowMenu(Action action) {
        super(action);
        this.init();
    }

    public WindowMenu(String string, boolean bl) {
        super(string, bl);
        this.init();
    }

    private void init() {
        this.m_winSep = new QDSeparator();
        super.add((Component)this.m_winSep);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem2 = this.getItem(i);
            if (jMenuItem2 != this.m_winSep) continue;
            return super.insert(jMenuItem, i);
        }
        return super.add(jMenuItem);
    }

    public void addFrame(FmtFrameBase fmtFrameBase) {
        WindowMenuItem windowMenuItem = new WindowMenuItem(fmtFrameBase);
        windowMenuItem.addActionListener(new FrameItemListener(fmtFrameBase));
        fmtFrameBase.addInternalFrameListener(new FrameListener());
        super.add((JMenuItem)((Object)windowMenuItem));
    }

    public void removeFrame(FmtFrameBase fmtFrameBase) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            WindowMenuItem windowMenuItem;
            JMenuItem jMenuItem = this.getItem(i);
            if (!(jMenuItem instanceof WindowMenuItem) || (windowMenuItem = (WindowMenuItem)((Object)jMenuItem)).getFrame() != fmtFrameBase) continue;
            this.remove(i);
            return;
        }
    }

    public void updateFrame(FmtFrameBase fmtFrameBase) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            WindowMenuItem windowMenuItem;
            JMenuItem jMenuItem = this.getItem(i);
            if (!(jMenuItem instanceof WindowMenuItem) || (windowMenuItem = (WindowMenuItem)((Object)jMenuItem)).getFrame() != fmtFrameBase) continue;
            windowMenuItem.setText(this.getDisplayName(fmtFrameBase));
            return;
        }
    }

    public void selectFrame(FmtFrameBase fmtFrameBase) {
        try {
            if (fmtFrameBase.isIcon()) {
                fmtFrameBase.setMaximum(true);
                fmtFrameBase.setMaximum(false);
            } else {
                fmtFrameBase.setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            MsgLog.error("Internal Error: Frame select failed");
        }
    }

    private String getDisplayName(FmtFrameBase fmtFrameBase) {
        return fmtFrameBase.getTitle();
    }

    private void updateSelection() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (!(jMenuItem instanceof WindowMenuItem)) continue;
            WindowMenuItem windowMenuItem = (WindowMenuItem)((Object)jMenuItem);
            FmtFrameBase fmtFrameBase = windowMenuItem.getFrame();
            fmtFrameBase.setAsActive(fmtFrameBase.isSelected());
            windowMenuItem.setSelected(fmtFrameBase.isSelected());
        }
    }

    private class FrameListener
    implements InternalFrameListener {
        private FrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            WindowMenu.this.updateSelection();
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            WindowMenu.this.updateSelection();
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            WindowMenu.this.updateSelection();
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            WindowMenu.this.updateSelection();
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }
    }

    private class WindowMenuItem
    extends QDCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private FmtFrameBase m_frame;

        public WindowMenuItem(FmtFrameBase fmtFrameBase) {
            this.m_frame = fmtFrameBase;
            this.setText(WindowMenu.this.getDisplayName(this.m_frame));
            fmtFrameBase.addPropertyChangeListener("name", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WindowMenuItem.this.setText(WindowMenu.this.getDisplayName(WindowMenuItem.this.m_frame));
                }
            });
        }

        public FmtFrameBase getFrame() {
            return this.m_frame;
        }
    }

    private class FrameItemListener
    implements ActionListener {
        private FmtFrameBase m_frame;

        public FrameItemListener(FmtFrameBase fmtFrameBase) {
            this.m_frame = fmtFrameBase;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowMenu.this.selectFrame(this.m_frame);
        }
    }
}

